<?php
/*
Plugin Name: MT Atis
Plugin URI: 
Description: The plugin is required to run Atis theme
Author: matchthemes
Author URI: https://matchthemes.com
Text Domain: atis
Domain Path: /languages
Version: 1.0.5
License: GNU General Public License v3.0
License URI: http://www.opensource.org/licenses/gpl-license.php
*/


// Add Custom Post Types

add_action('init', 'atis_custom_post_types');

function atis_custom_post_types() {
	
	// load language files.
	load_plugin_textdomain( 'atis', false, dirname( plugin_basename( __FILE__ ) ) . '/languages' );
	
	// Practice Areas Custom Post Type
	
	$match_practice_labels = array(
		'name' => esc_html__('Practice Areas', 'atis'),
		'singular_name' => esc_html__('Practice Item', 'atis'),
		'add_new' => esc_html__('Add New Practice Item', 'atis'),
		'add_new_item' => esc_html__('Add New Practice Item', 'atis'),
		'edit_item' => esc_html__('Edit Practice Item', 'atis'),
		'new_item' => esc_html__('New Practice Item', 'atis'),
		'all_items' => esc_html__( 'All Practice Areas', 'atis' ),
		'view_item' => esc_html__('View Practice Item', 'atis'),
		'search_items' => esc_html__('Search Practice', 'atis'),
		'not_found' =>  esc_html__('Nothing found', 'atis'),
		'not_found_in_trash' => esc_html__('Nothing found in Trash', 'atis'),
		'parent_item_colon' => ''
		);
	
    	$match_practice_args = array(
        	'labels' => $match_practice_labels,        	
        	'public' => true,
        	'show_ui' => true,
			'menu_icon' => 'dashicons-portfolio',
        	'capability_type' => 'post',
			'show_in_rest' => true,
        	'hierarchical' => false,
        	'rewrite' => array('slug' => 'practice-area','with_front' => false),
        	'supports' => array('title', 'editor', 'thumbnail', 'excerpt')
        );
		register_post_type('match_practice_areas',$match_practice_args);	

		
// Team Custom Post Type

$labelsTeam = array(
		'name' => esc_html__('Team', 'atis'),
		'singular_name' => esc_html__('Team Item', 'atis'),
		'add_new' => esc_html__('Add New Team Item', 'atis'),
		'add_new_item' => esc_html__('Add New Team Item', 'atis'),
		'edit_item' => esc_html__('Edit Team Item', 'atis'),
		'new_item' => esc_html__('New Team Item', 'atis'),
		'view_item' => esc_html__('View Team Item', 'atis'),
		'all_items' => esc_html__( 'All Team', 'atis' ),
		'search_items' => esc_html__('Search Team Item', 'atis'),
		'not_found' =>  esc_html__('Nothing found', 'atis'),
		'not_found_in_trash' => esc_html__('Nothing found in Trash', 'atis'),
		'parent_item_colon' => ''
		);
	
    	$team_args = array(
        	'labels' => $labelsTeam,
        	'public' => true,
        	'show_ui' => true,
			'menu_icon' => 'dashicons-groups',
        	'capability_type' => 'post',
			'show_in_rest' => true,
        	'hierarchical' => false,
        	'rewrite' => array('slug' => 'team','with_front' => false),
        	'supports' => array('title', 'editor', 'thumbnail', 'excerpt')
        );
		register_post_type('match_team',$team_args);

// Case Studies Custom Post Type

$labelsCase = array(
		'name' => esc_html__('Case Studies', 'atis'),
		'singular_name' => esc_html__('Case Item', 'atis'),
		'add_new' => esc_html__('Add New Case Item', 'atis'),
		'add_new_item' => esc_html__('Add New Case Item', 'atis'),
		'edit_item' => esc_html__('Edit Case Item', 'atis'),
		'new_item' => esc_html__('New Case Item', 'atis'),
		'view_item' => esc_html__('View Case Item', 'atis'),
		'all_items' => esc_html__( 'All Cases', 'atis' ),
		'search_items' => esc_html__('Search Case Item', 'atis'),
		'not_found' =>  esc_html__('Nothing found', 'atis'),
		'not_found_in_trash' => esc_html__('Nothing found in Trash', 'atis'),
		'parent_item_colon' => ''
		);
	
    	$case_args = array(
        	'labels' => $labelsCase,      	
        	'public' => true,
        	'show_ui' => true,
			'menu_icon' => 'dashicons-book',
        	'capability_type' => 'post',
			'show_in_rest' => true,
        	'hierarchical' => false,
        	'rewrite' => array('slug' => 'case','with_front' => false),
        	'supports' => array('title', 'editor', 'thumbnail', 'excerpt')
        );
		register_post_type('match_case_studies',$case_args);		
		
// Testimonials Custom Post Type
		
	$match_testimonials_labels = array(
		'name' => esc_html__('Testimonials', 'atis'),
		'singular_name' => esc_html__('Testimonial Item', 'atis'),
		'add_new' => esc_html__('Add New Testimonial', 'atis'),
		'add_new_item' => esc_html__('Add New Testimonial Item', 'atis'),
		'edit_item' => esc_html__('Edit Testimonial Item', 'atis'),
		'new_item' => esc_html__('New Testimonial Item', 'atis'),
		'view_item' => esc_html__('View Testimonial Item', 'atis'),
		'all_items' => esc_html__( 'All Testimonials', 'atis' ),
		'search_items' => esc_html__('Search Testimonials', 'atis'),
		'not_found' =>  esc_html__('Nothing found', 'atis'),
		'not_found_in_trash' => esc_html__('Nothing found in Trash', 'atis'),
		'parent_item_colon' => ''
		);
	
    	$match_testimonials_args = array(
        	'labels' => $match_testimonials_labels,    	
        	'public' => true,
        	'show_ui' => true,
			'menu_icon' => 'dashicons-testimonial',
        	'capability_type' => 'post',
			'show_in_rest' => true,
        	'hierarchical' => false,
        	'rewrite' => array('slug' => 'testimonial','with_front' => false),
        	'supports' => array('title', 'editor', 'thumbnail')
        );
		register_post_type('match_testimonials',$match_testimonials_args);	
	
}

// Shortcodes

add_action('init', 'atis_shortcodes');

function atis_shortcodes() {

require_once( 'shortcodes.php' );

}

/**
 * Atis_Recent_Posts_Img_Widget
 */
add_action( 'widgets_init', 'atis_recent_posts_img' );

function atis_recent_posts_img() {
	register_widget( 'atis_Recent_Posts_Img_Widget' );
}

/**
 Widget class.
 */
class atis_Recent_Posts_Img_Widget extends WP_Widget {

	/**
	 * Widget setup.
	 */
	function __construct() {
		/* Widget settings. */
		$widget_ops = array( 'classname' => 'atis_recent_posts_img_w', 'description' => esc_html__('Display recent posts with image thumbnail.', 'atis') );
		
		
		/* Create the widget. */
		parent::__construct( 'atis_recent_posts_img_w', esc_html__('MT - Recent Posts with Image', 'atis'), $widget_ops );
	}

	/**
	 *display the widget on the screen.
	 */
	function widget( $args, $instance ) {
		extract( $args );
		
	    $recent_posts_title = $instance['recent_posts_title'];
		$nr_articles = $instance['nr_articles'];
		
		//If the function icl_translate exist, forces the string to register for translation in String Translation.
     if ( function_exists( 'icl_translate' ) ) {
        $recent_posts_title = icl_translate( 'wpml_custom', 'wpml_custom_recent_posts_title_'. $widget_id, $recent_posts_title );
			           
		  }
		
		/* Before widget (defined by themes). */
		echo $before_widget;

		/* Display the widget title if one was input (before and after defined by themes). */
		if ( $recent_posts_title )
			echo $before_title . $recent_posts_title . $after_title;
		?>
        
   		<div class="widget-display-posts-img">
                  
                    <ul>
            			<?php 
						$query = array('posts_per_page' => $nr_articles, 'ignore_sticky_posts'=>true);
						
						$recPosts = new WP_Query($query);

						while ($recPosts->have_posts()) : $recPosts->the_post(); ?>
                        
                        <li>
                       
                       <div class="display-post-holder">
                       
                        <?php if (  (function_exists('has_post_thumbnail')) && (has_post_thumbnail())  ) : /* if post has post thumbnail */ ?>
                       
                             <div class="display-post-img">
       <a href="<?php the_permalink() ?>" title="<?php the_title_attribute(); ?>"><?php the_post_thumbnail('thumbnail', array('class'=> 'img-fluid', 'alt' => ''.get_the_title().'', 'title' => ''.get_the_title().'')); ?> </a>
       </div>
          <?php endif; ?>
    
    <div class="display-post-text">
    <p class="display-post-date"><?php echo get_the_date(get_option('date_format')); ?></p>
    <div class="display-post-title"><a href="<?php the_permalink() ?>"><?php the_title(); ?></a></div>
    </div>
    
    </div><!--recent-post-holder-->
    
         </li>
                        
                        <?php endwhile; ?>
                        
                        <?php wp_reset_postdata(); ?>

                    </ul>
                  
                </div><!--sidebar-articles-->
       
	   <?php
		
		/* After widget (defined by themes). */
		echo $after_widget;
	}

	/**
	 * Displays the widget settings controls on the widget panel.
	 * Make use of the get_field_id() and get_field_name() function
	 * when creating your form elements. This handles the confusing stuff.
	 */
	function form( $instance ) {

		/* Set up some default widget settings. */
		$defaults = array(
		'recent_posts_title' => '',
		'nr_articles' => '5'
		);
		$instance = wp_parse_args( (array) $instance, $defaults ); ?>

     <p><label for="<?php echo esc_attr($this->get_field_id( 'recent_posts_title' )); ?>"><?php esc_html_e('Title:', 'atis'); ?></label>
        <input type="text" id="<?php echo esc_attr($this->get_field_id('recent_posts_title')); ?>" name="<?php echo esc_attr($this->get_field_name('recent_posts_title')); ?>" value="<?php echo esc_attr($instance['recent_posts_title']); ?>" style="width:100%;" /></p>
		
  <p><label for="<?php echo esc_attr($this->get_field_id( 'nr_articles' )); ?>"><?php esc_html_e('Number of articles:', 'atis'); ?></label>
 <input type="text" id="<?php echo esc_attr($this->get_field_id('nr_articles')); ?>" name="<?php echo esc_attr($this->get_field_name('nr_articles')); ?>" value="<?php echo esc_attr($instance['nr_articles']); ?>" style="width:100%;" /></p>
 
 	<?php
	}
}