<?php

/*
1. Practice Areas Shortcodes
2. Team Shortcodes
3. Case Studies Shortcodes
4. Testimonials Shortcodes
5. Blog Shortcodes

*/

// 1. Practice Areas Shortcodes

/* Practice Image v1  */

function atis_shortcode_practice_image_v1( $atts ){ 

extract( shortcode_atts( array(
    'id'          => '',
	'cols'          => '3',
    'count'       => '12',
  ), $atts, 'practice_img_v1' ) );
  

	$output = '';
	
	$practice_args = array('post_type' => 'match_practice_areas', 'posts_per_page' => esc_attr( $count ) );
	$practice_query = new WP_Query($practice_args);
	
	if (!empty($id)) $output .= '<div id="'. esc_attr( $id ) .'">';
	
	$output .= '<div class="practice-short-img-v1 practice-img-holder-v1">';
	
	if ($practice_query -> have_posts()) : while ($practice_query -> have_posts()) : $practice_query -> the_post();
	
	if ( function_exists( 'get_field' )):
	
	$match_practice_subtitle =  get_field("match_practice_subtitle");
	$match_practice_icon =  get_field("match_practice_icon");
	$match_practice_ficon =  get_field("match_practice_ficon");
		
	endif;
	
	switch ($cols):
	
	case '5':
        $output .= '<div class="practice-image-wrap practice-image-wrap-v1 practice-5col">';
        break;
	case '4':
        $output .= '<div class="practice-image-wrap practice-image-wrap-v1 practice-4col">';
        break;
	case '3':
        $output .= '<div class="practice-image-wrap practice-image-wrap-v1 practice-3col">';
        break;
	case '2':
        $output .= '<div class="practice-image-wrap practice-image-wrap-v1 practice-2col">';
        break;	

	default:
        $output .= '<div class="practice-image-wrap practice-image-wrap-v1 practice-3col">';
	
	endswitch;
	
	$output .= '<a href="'. get_permalink() .'"><div class="practice-img">'. get_the_post_thumbnail( get_the_ID(), 'atis-image700x700', array( 'class' => 'img-fluid' )). '</div></a>';
	
	$output .= '<span class="practice-subtitle">'. $match_practice_subtitle .'</span>';
	$output .= '<h3><a href="'. get_permalink() .'">'. get_the_title() .'</a></h3>';

	if (!empty(get_the_excerpt())):
		
	$output .= '<div class="practice-img-content">'. wp_trim_words( get_the_excerpt(), 18, '' ) .'</div>';
	
	endif;	
	
	$output .= '<a class="read-more" href="'. get_permalink() .'">' . esc_html__('View More', 'atis') .'</a>';

	$output .= '</div>';
	
	endwhile; endif; wp_reset_postdata();
	
	$output .= '</div>';
	
	if (!empty($id)) $output .= '</div>';
	
	return $output;
	
	}

add_shortcode( 'practice_img_v1', 'atis_shortcode_practice_image_v1' );

/* Practice Image v2  */

function atis_shortcode_practice_image_v2( $atts ){ 

extract( shortcode_atts( array(
    'id'          => '',
	'cols'          => '3',
    'count'       => '12',
  ), $atts, 'practice_img_v2' ) );
  

	$output = '';
	
	$practice_args = array('post_type' => 'match_practice_areas', 'posts_per_page' => esc_attr( $count ) );
	$practice_query = new WP_Query($practice_args);
	
	if (!empty($id)) $output .= '<div id="'. esc_attr( $id ) .'">';
	
	$output .= '<div class="practice-short-img-v2 practice-img-holder-v2">';
	
	if ($practice_query -> have_posts()) : while ($practice_query -> have_posts()) : $practice_query -> the_post();
	
	if ( function_exists( 'get_field' )):
	
	$match_practice_subtitle =  get_field("match_practice_subtitle");
	$match_practice_ficon =  get_field("match_practice_ficon");
		
	endif;
	
	switch ($cols):
	
	case '5':
        $output .= '<div class="practice-image-wrap practice-image-wrap-v2 practice-5col"><div class="practice-image-v2">';
        break;
	
	case '4':
        $output .= '<div class="practice-image-wrap practice-image-wrap-v2 practice-4col"><div class="practice-image-v2">';
        break;
	case '3':
        $output .= '<div class="practice-image-wrap practice-image-wrap-v2 practice-3col"><div class="practice-image-v2">';
        break;
	case '2':
        $output .= '<div class="practice-image-wrap practice-image-wrap-v2 practice-2col"><div class="practice-image-v2">';
        break;	

	default:
        $output .= '<div class="practice-image-wrap practice-image-wrap-v2 practice-3col"><div class="practice-image-v2">';
	
	endswitch;
	
	if ( has_post_thumbnail( get_the_ID() ) ): $image = wp_get_attachment_image_src( get_post_thumbnail_id( get_the_ID() ), 'atis-image700x700' );
	
	$output .= '<a href="'. get_permalink() .'"><div class="practice-img-bkg" style="background-image:url('.$image[0].');"></div></a>';
	
	else:
	
	$output .= '<div class="practice-img-bkg"></div>';
	
	endif;
	
	$output .= '<div class="icon-top-img">'. $match_practice_ficon .'</div>';
	$output .= '<div class="practice-content-v2"><span class="practice-subtitle">'. $match_practice_subtitle .'</span>';
	$output .= '<h3><a href="'. get_permalink() .'">'. get_the_title() .'</a></h3></div>';
	
	$output .= '<div class="practice-v2-more"><a class="post-more" href="'. get_permalink() .'">' . esc_html__('View More', 'atis') .'</a></div>';

	$output .= '</div></div>';
	
	endwhile; endif; wp_reset_postdata();
	
	$output .= '</div>';
	
	if (!empty($id)) $output .= '</div>';
	
	return $output;
	
	}

add_shortcode( 'practice_img_v2', 'atis_shortcode_practice_image_v2' );

/* Practice Icons v1  */

function atis_shortcode_practice_icon_v1( $atts ){ 

extract( shortcode_atts( array(
    'id'          => '',
	'cols'          => '3',
    'count'       => '12',
	'use_ficon'       => '',
	'bkg'       => '',
  ), $atts, 'practice_icon_v1' ) );
  

	$output = '';
	
	$practice_args = array('post_type' => 'match_practice_areas', 'posts_per_page' => esc_attr( $count ) );
	$practice_query = new WP_Query($practice_args);
	
	if (!empty($id)): $output .= '<div id="'. esc_attr( $id ) .'" class="practice-short-icon-v1 practice-icons-holder-v1">';
	
	else: $output .= '<div class="practice-short-icon-v1 practice-icons-holder-v1">';
	
	endif;
	
	if ($practice_query -> have_posts()) : while ($practice_query -> have_posts()) : $practice_query -> the_post();
	
	if ( function_exists( 'get_field' )):
	
	$match_practice_subtitle =  get_field("match_practice_subtitle");
	$match_practice_icon =  get_field("match_practice_icon");
	$match_practice_ficon =  get_field("match_practice_ficon");
		
	endif;
	
	switch ($cols):
	
	case '4':
        $output .= '<div class="practice-icon practice-icon-v1 practice-4col">';
        break;
	case '3':
        $output .= '<div class="practice-icon practice-icon-v1 practice-3col">';
        break;
		
	case '2':
        $output .= '<div class="practice-icon practice-icon-v1 practice-2col">';
        break;	

	default:
        $output .= '<div class="practice-icon practice-icon-v1 practice-3col">';
	
	endswitch;
	
	if (($bkg == 'on')):
	
	$output .= '<div class="practice-icon-wrap practice-bkg">';
	
	else:
	
	$output .= '<div class="practice-icon-wrap">';
	
	endif;
	
	$output .= '<div class="practice-top-v1">';
	
	if ((!empty($match_practice_icon)) && ($use_ficon != 'on') ):
	
	$output .= '<div class="icon-top icon-top-v1"><a href="'. get_permalink() .'"><img src="'. $match_practice_icon["url"] .'" alt="'. $match_practice_icon["caption"] .'"/></a></div>';
	
	else: if (!empty($match_practice_ficon)):
	
	$output .= '<div class="icon-top icon-top-v1"><a href="'. get_permalink() .'">'. $match_practice_ficon .'</a></div>';
	
	endif;
	endif;
	
	$output .= '<div class="icon-title-holder"><span class="practice-subtitle">'. $match_practice_subtitle .'</span>';
	$output .= '<h3><a href="'. get_permalink() .'">'. get_the_title() .'</a></h3></div>';
	
	$output .= '</div>';

	if (!empty(get_the_excerpt())):
		
	$output .= '<div class="practice-icon-content practice-icon-content-v1">'. wp_trim_words( get_the_excerpt(), 25, '' ) .'</div>';
	
	endif;	
	
	$output .= '</div></div>';
	
	endwhile; endif; wp_reset_postdata();
	
	$output .= '</div>';
	
	return $output;
	
	}

add_shortcode( 'practice_icon_v1', 'atis_shortcode_practice_icon_v1' );

/* Practice Icons v2  */

function atis_shortcode_practice_icon_v2( $atts ){ 

extract( shortcode_atts( array(
    'id'          => '',
	'cols'          => '3',
    'count'       => '12',
	'use_ficon'       => '',
  ), $atts, 'practice_icon_v2' ) );
  

	$output = '';
	
	$practice_args = array('post_type' => 'match_practice_areas', 'posts_per_page' => esc_attr( $count ) );
	$practice_query = new WP_Query($practice_args);
	
	if (!empty($id)): $output .= '<div id="'. esc_attr( $id ) .'" class="practice-short-icon-v2 practice-icons-holder-v2">';
	
	else: $output .= '<div class="practice-short-icon-v2 practice-icons-holder-v2">';
	
	endif;
	
	if ($practice_query -> have_posts()) : while ($practice_query -> have_posts()) : $practice_query -> the_post();
	
	if ( function_exists( 'get_field' )):
	
	$match_practice_icon =  get_field("match_practice_icon");
	$match_practice_ficon =  get_field("match_practice_ficon");
		
	endif;
	
	switch ($cols):
	
	case '5':
        $output .= '<div class="practice-icon practice-icon-v2 practice-5col"><div class="practice-icon-wrap">';
        break;
	case '4':
        $output .= '<div class="practice-icon practice-icon-v2 practice-4col"><div class="practice-icon-wrap">';
        break;
	case '3':
        $output .= '<div class="practice-icon practice-icon-v2 practice-3col"><div class="practice-icon-wrap">';
        break;
		
	case '2':
        $output .= '<div class="practice-icon practice-icon-v2 practice-2col"><div class="practice-icon-wrap">';
        break;	

	default:
        $output .= '<div class="practice-icon practice-icon-v2 practice-3col"><div class="practice-icon-wrap">';
	
	endswitch;
	
	if ((!empty($match_practice_icon)) && ($use_ficon != 'on') ):
	
	$output .= '<div class="icon-top"><img src="'. $match_practice_icon["url"] .'" alt="'. $match_practice_icon["caption"] .'"/></div>';
	
	else: if (!empty($match_practice_ficon)):
	
	$output .= '<div class="icon-top">'. $match_practice_ficon .'</div>';
	
	endif;
	endif;
	
	$output .= '<h3><a href="'. get_permalink() .'">'. get_the_title() .'</a></h3>';

	if (!empty(get_the_excerpt())):
		
	$output .= '<div class="practice-icon-content">'. wp_trim_words( get_the_excerpt(), 15, '' ) .'</div>';
	
	endif;	
	
	$output .= '<a class="read-more" href="'. get_permalink() .'">' . esc_html__('View More', 'atis') .'</a>';

	$output .= '</div></div>';
	
	endwhile; endif; wp_reset_postdata();
	
	$output .= '</div>';
	
	return $output;
	
	}

add_shortcode( 'practice_icon_v2', 'atis_shortcode_practice_icon_v2' );

/* Practice Areas List  */

function atis_shortcode_practice_list( $atts ){ 

extract( shortcode_atts( array(
    'id' => '',
	'count' => '12',
  ), $atts, 'practice_list' ) );
  
		global $post;
		$gId  = $post->ID;
		
	$output = '';
	
	$practice_args = array('post_type' => 'match_practice_areas', 'posts_per_page' => esc_attr( $count ));
	$practice_query = new WP_Query($practice_args);
	
	if (!empty($id)): $output .= '<div id="'. esc_attr( $id ) .'" class="widget practice-short-list">';
	
	else: $output .= '<div class="widget practice-short-list">';
	
	endif;
	
	if ($practice_query -> have_posts()) : 
	
	$output .= '<ul class="list-practice">';
	
	while ($practice_query -> have_posts()) : $practice_query -> the_post();
	
	$current_post = get_the_ID();
	
	if ( $gId == $current_post ):
	
	$output .= '<li class="practice-active"><a href="'. get_permalink() .'">'. get_the_title() .'</a></li>';
	
	else:
	
	$output .= '<li><a href="'. get_permalink() .'">'. get_the_title() .'</a></li>';
	
	endif;
	
	endwhile; 
	
	$output .= '</ul>';
	
	endif; wp_reset_postdata();
	
	$output .= '</div>';
	
	return $output;
	
	}

add_shortcode( 'practice_list', 'atis_shortcode_practice_list' );


// 2. Team Shortcodes

/* Team v1  */

function atis_shortcode_team_v1( $atts ){ 

extract( shortcode_atts( array(
    'id' => '',
	'cols' => '3',
    'count' => '12',
	'name' => ''
  ), $atts, 'team_v1' ) );
  
	$output = '';
	
	if (empty($name)):
	
	$blog_args = array('post_type' => 'match_team', 'posts_per_page' => esc_attr( $count ) );
		
	else:
	
	$match_postsIDS = explode(',', $name);
	
	$blog_args = array('post_type' => 'match_team', 'post_name__in' => $match_postsIDS, 'orderby' => 'post_name__in' );
	
	endif;	
		
	$blog_query = new WP_Query($blog_args);
		
	if (!empty($id)): $output .= '<div id="'. esc_attr( $id ) .'" class="team-short-v1 team-holder-v1">';
	
	else: $output .= '<div class="team-short-v1 team-holder-v1">';
	
	endif;
	
	if ($blog_query -> have_posts()) : while ($blog_query -> have_posts()) : $blog_query -> the_post();
	
	if ( function_exists( 'get_field' )):
	
	 $match_team_position =  get_field("match_team_position"); 
	 $match_team_twitter_url =  get_field("match_team_twitter_url");
	 $match_team_facebook_url =  get_field("match_team_facebook_url");
	 $match_team_linkedin_url =  get_field("match_team_linkedin_url");
	 $match_team_mail =  get_field("match_team_mail");
		
	endif;
	
	switch ($cols):
	
	case '4':
        $output .= '<div class="team-wrap team-wrap-v1 practice-4col">';
        break;
	case '3':
        $output .= '<div class="team-wrap team-wrap-v1 practice-3col">';
        break;
	case '2':
        $output .= '<div class="team-wrap team-wrap-v1 practice-2col">';
        break;	

	default:
        $output .= '<div class="team-wrap team-wrap-v1 practice-3col">';
	
	endswitch;
	
	$output .= '<a href="'. get_permalink() .'"><div class="practice-img">'. get_the_post_thumbnail( get_the_ID(), 'atis-image700x700', array( 'class' => 'img-fluid' )). '</div></a>';
	
	$output .= '<span class="practice-subtitle">'. $match_team_position .'</span>';
	$output .= '<h3><a href="'. get_permalink() .'">'. get_the_title() .'</a></h3>';

		
	$output .= '<div class="team-social"><ul class="social-media">';
	
	if(!empty( $match_team_facebook_url )):
	
	$output .= '<li><a class="social-facebook" href="'. $match_team_facebook_url .'" target="_blank"><i class="fab fa-facebook-f"></i></a></li>';
	
	endif;
	
	if(!empty( $match_team_twitter_url )):
	
	$output .= '<li><a class="social-twitter" href="'. $match_team_twitter_url .'" target="_blank"><i class="fab fa-twitter"></i></a></li>';	
	
	endif;
	
	if(!empty( $match_team_linkedin_url )):
	
	$output .= '<li><a class="social-linkedin" href="'. $match_team_linkedin_url .'" target="_blank"><i class="fab fa-linkedin-in"></i></a></li>';
	
	endif;
	
	if(!empty( $match_team_mail )):
	
	$output .= '<li><a class="social-email" href="mailto:'. $match_team_mail .'" target="_blank"><i class="far fa-envelope"></i></a></li>';
	
	endif;	
	
	$output .= '</ul></div>';

	$output .= '</div>';
	
	endwhile; endif; wp_reset_postdata();
	
	$output .= '</div>';
	
	return $output;
	
	}

add_shortcode( 'team_v1', 'atis_shortcode_team_v1' );

/* Team v2  */

function atis_shortcode_team_v2( $atts ){ 

extract( shortcode_atts( array(
    'id' => '',
	'cols' => '3',
    'count' => '12',
	'name' =>'',
  ), $atts, 'team_v2' ) );
  

	$output = '';
	
	if (empty($name)):
	
	$blog_args = array('post_type' => 'match_team', 'posts_per_page' => esc_attr( $count ) );
		
	else:
	
	$match_postsIDS = explode(',', $name);
	
	$blog_args = array('post_type' => 'match_team', 'post_name__in' => $match_postsIDS, 'orderby' => 'post_name__in'  );
	
	endif;	
		
	$blog_query = new WP_Query($blog_args);
	
	if (!empty($id)): $output .= '<div id="'. esc_attr( $id ) .'" class="team-short-v2 team-holder-v2">';
	
	else: $output .= '<div class="team-short-v2 team-holder-v2">';
	
	endif;
	
	if ($blog_query -> have_posts()) : while ($blog_query -> have_posts()) : $blog_query -> the_post();
	
	if ( function_exists( 'get_field' )):
	
	$match_team_position =  get_field("match_team_position"); 
	 $match_team_twitter_url =  get_field("match_team_twitter_url");
	 $match_team_facebook_url =  get_field("match_team_facebook_url");
	 $match_team_linkedin_url =  get_field("match_team_linkedin_url");
	 $match_team_mail =  get_field("match_team_mail");
		
	endif;
	
	switch ($cols):
	
	case '4':
        $output .= '<div class="team-wrap team-wrap-v2 practice-4col"><div class="team-v2">';
        break;
	case '3':
        $output .= '<div class="team-wrap team-wrap-v2 practice-3col"><div class="team-v2">';
        break;
	case '2':
        $output .= '<div class="team-wrap team-wrap-v2 practice-2col"><div class="team-v2">';
        break;	

	default:
        $output .= '<div class="team-wrap team-wrap-v2 practice-3col"><div class="team-v2">';
	
	endswitch;
	
	if ( has_post_thumbnail( get_the_ID() ) ): $image = wp_get_attachment_image_src( get_post_thumbnail_id( get_the_ID() ), 'atis-image700x700' );
	
	$output .= '<a href="'. get_permalink() .'"><div class="team-img-bkg" style="background-image:url('.$image[0].');"></div></a>';
	
	else:
	
	$output .= '<div class="team-img-bkg"></div>';
	
	endif;
	
	$output .= '<div class="practice-content-v2"><span class="practice-subtitle">'. $match_team_position .'</span>';
	$output .= '<h3><a href="'. get_permalink() .'">'. get_the_title() .'</a></h3></div>';
	
	$output .= '<div class="team-social-v2"><ul class="social-media">';
		
	if(!empty( $match_team_facebook_url )):
	
	$output .= '<li><a class="social-facebook" href="'. $match_team_facebook_url .'" target="_blank"><i class="fab fa-facebook-f"></i></a></li>';
	
	endif;
	
	if(!empty( $match_team_twitter_url )):
	
	$output .= '<li><a class="social-twitter" href="'. $match_team_twitter_url .'" target="_blank"><i class="fab fa-twitter"></i></a></li>';	
	
	endif;
	
	if(!empty( $match_team_linkedin_url )):
	
	$output .= '<li><a class="social-linkedin" href="'. $match_team_linkedin_url .'" target="_blank"><i class="fab fa-linkedin-in"></i></a></li>';
	
	endif;
	
	if(!empty( $match_team_mail )):
	
	$output .= '<li><a class="social-email" href="mailto:'. $match_team_mail .'" target="_blank"><i class="far fa-envelope"></i></a></li>';
	
	endif;	
	
	$output .= '</ul></div>';

	$output .= '</div></div>';
	
	endwhile; endif; wp_reset_postdata();
	
	$output .= '</div>';
	
	return $output;
	
	}

add_shortcode( 'team_v2', 'atis_shortcode_team_v2' );

// 3. Case Studies Shortcodes

function atis_shortcode_case_studies( $atts ){ 

extract( shortcode_atts( array(
    'id' => '',
	'cols' => '3',
    'count' => '12',
  ), $atts, 'case_studies' ) );
  

	$output = '';
		
	$blog_args = array('post_type' => 'match_case_studies', 'posts_per_page' => esc_attr( $count ) );
		
	$blog_query = new WP_Query($blog_args);
	
	if (!empty($id)): $output .= '<div id="'. esc_attr( $id ) .'" class="cases-short cases-holder">';
	
	else: $output .= '<div class="cases-short cases-holder">';
	
	endif;
	
	if ($blog_query -> have_posts()) : while ($blog_query -> have_posts()) : $blog_query -> the_post();
	
	switch ($cols):
	
	case '5':
        $output .= '<div class="case-wrap practice-5col"><div class="case-item">';
        break;
	
	case '4':
        $output .= '<div class="case-wrap practice-4col"><div class="case-item">';
        break;
	case '3':
        $output .= '<div class="case-wrap practice-3col"><div class="case-item">';
        break;
	case '2':
        $output .= '<div class="case-wrap practice-2col"><div class="case-item">';
        break;	

	default:
        $output .= '<div class="case-wrap practice-3col"><div class="case-item">';
	
	endswitch;
	
	if ( has_post_thumbnail( get_the_ID() ) ): $image = wp_get_attachment_image_src( get_post_thumbnail_id( get_the_ID() ), 'atis-image700x700' );
	
	$output .= '<a href="'. get_permalink() .'"><div class="case-img-bkg" style="background-image:url('.$image[0].');"></div></a>';
	
	else:
	
	$output .= '<div class="case-img-bkg"></div>';
	
	endif;
	
	$output .= '<div class="case-content"><span class="practice-subtitle">'. get_the_excerpt() .'</span>';
	$output .= '<h3><a href="'. get_permalink() .'">'. get_the_title() .'</a></h3></div>';
	
	$output .= '</div></div>';
	
	endwhile; endif; wp_reset_postdata();
	
	$output .= '</div>';
	
	return $output;
	
	}

add_shortcode( 'case_studies', 'atis_shortcode_case_studies' );

/* Cases List  */

function atis_shortcode_cases_list( $atts ){ 

extract( shortcode_atts( array(
    'id' => '',
	'count' => '12',
  ), $atts, 'cases_list' ) );
  
	global $post;
	$gId  = $post->ID;  

	$output = '';
	
	$practice_args = array('post_type' => 'match_case_studies', 'posts_per_page' => esc_attr( $count ));
	$practice_query = new WP_Query($practice_args);
	
	if (!empty($id)): $output .= '<div id="'. esc_attr( $id ) .'" class="widget cases-short-list">';
	
	else: $output .= '<div class="widget cases-short-list">';
	
	endif;
	
	if ($practice_query -> have_posts()) : 
	
	$output .= '<ul class="list-practice">';
	
	while ($practice_query -> have_posts()) : $practice_query -> the_post();
	
	$current_post = get_the_ID();
	
	if ( $gId == $current_post ):
	
	$output .= '<li class="practice-active"><a href="'. get_permalink() .'">'. get_the_title() .'</a></li>';
	
	else:
	
	$output .= '<li><a href="'. get_permalink() .'">'. get_the_title() .'</a></li>';
	
	endif;
	
	endwhile; 
	
	$output .= '</ul>';
	
	endif; wp_reset_postdata();
	
	$output .= '</div>';
	
	return $output;
	
	}

add_shortcode( 'cases_list', 'atis_shortcode_cases_list' );

// 4. Testimonials Shortcode

function atis_shortcode_testimonials( $atts ){ 

extract( shortcode_atts( array(
    'id'          => '',
    'count'       => '12',
  ), $atts, 'testimonials' ) );
  
	$output = '';
	
	if (!empty($id)) $output .= '<div class="'. esc_attr( $id ) .'">';
	
	$output .= '<div class="testimonial-quote"><div hidden>
        <svg xmlns="http://www.w3.org/2000/svg" style="display: none;"><symbol id="left-quote" viewBox="0 0 64 64"><title>left-quote</title><path d="M50.6292648,26.225668c-0.1288986-1.3934994-0.0303001-5.1816006,3.5985985-10.4492006 c0.2745018-0.3975,0.2247009-0.9335995-0.1161957-1.2743998c-1.4795036-1.4794998-2.395504-2.4131002-3.0379982-3.0663996 c-0.8448029-0.8614006-1.2305031-1.2539005-1.795002-1.7657003c-0.3769035-0.3388004-0.9472008-0.3446999-1.3281021-0.0125999 c-6.3251991,5.5038996-13.3505974,16.8768997-12.3339958,30.8105011 c0.5956955,8.1815987,6.5634956,14.1200981,14.1894951,14.1200981c7.8260994,0,14.1932983-6.3661995,14.1932983-14.1923981 C63.9993629,32.845768,58.0736694,26.6543674,50.6292648,26.225668z M49.8060646,52.5879669 c-6.5489006,0-11.6767998-5.1581993-12.1953011-12.2645988c0,0,0,0,0-0.0009995 c-1.1435966-15.6709003,8.1718025-25.8496017,10.9863014-28.5449009c0.2743988,0.2705002,0.5878983,0.5887995,1.0498009,1.0594997 c0.5565987,0.5664005,1.3183975,1.3417997,2.4706993,2.4981003c-4.4053001,6.7870998-3.5741997,11.6229992-3.2099991,12.3164005 c0.1728973,0.3290997,0.5273972,0.5508003,0.8984985,0.5508003c6.7236023,0,12.1932983,5.469698,12.1932983,12.1933002 C61.9993629,47.1182671,56.5296669,52.5879669,49.8060646,52.5879669z"/><path d="M15.1136675,26.225668c-0.1299-1.3896008-0.0341997-5.1748009,3.5985994-10.4492006 c0.2735004-0.3975,0.2245998-0.9335995-0.1161995-1.2743998c-1.4766006-1.4765997-2.3915997-2.4091997-3.0332003-3.0625 c-0.8476-0.8633003-1.2343998-1.2568998-1.7987995-1.7695999c-0.3769999-0.3388004-0.9473-0.3437004-1.3281002-0.0136003 c-6.3251996,5.5039005-13.3515997,16.875-12.3369999,30.8115005v0.0009995 c0.5977,8.1805992,6.5664001,14.1190987,14.1924,14.1190987c7.8261995,0,14.1934004-6.3661995,14.1934004-14.1923981 C28.4847679,32.8448677,22.5589676,26.6524677,15.1136675,26.225668z M14.2913675,52.5879669 c-6.5478001,0-11.6786995-5.1581993-12.1982002-12.2655983v0.0009995 c-1.1406-15.6748009,8.1747999-25.8516006,10.9892006-28.5459003c0.2754002,0.2705002,0.5899,0.5908003,1.0528002,1.0625 c0.5555992,0.5663996,1.3163996,1.3408003,2.4667988,2.4951c-4.4052992,6.7880993-3.5741997,11.6229992-3.2099991,12.3153992 c0.1729002,0.3291016,0.5283003,0.5518017,0.8993998,0.5518017c6.7237005,0,12.1934004,5.469698,12.1934004,12.1933002 C26.4847679,47.1182671,21.0150681,52.5879669,14.2913675,52.5879669z"/></symbol></svg>    </div>
		
		<svg class="icon">
                      <use xlink:href="#left-quote"></use>
                  </svg>
		</div>';
	
	$blog_args = array('post_type' => 'match_testimonials', 'posts_per_page' => esc_attr( $count ) );
	$blog_query = new WP_Query($blog_args);
	
	$output .= '<div class="owl-carousel owl-theme testimonial-slider">';
	
	if ($blog_query -> have_posts()) : while ($blog_query -> have_posts()) : $blog_query -> the_post();
	
	$output .= '<div class="testimonial-info">'. get_the_content() .'</div>';
	
	endwhile; endif; wp_reset_postdata();
	
	$output .= '</div></div>';

return $output;

}

add_shortcode( 'testimonials', 'atis_shortcode_testimonials' );

// 5. Blog Shortcodes


/* Blog 3 Cols */

function atis_shortcode_blog_3cols( $atts ){ 

extract( shortcode_atts( array(
    'id'          => '',
    'count'       => '3',
  ), $atts, 'blog_3cols' ) );
  

	$output = '';
	
	$blog_args = array('post_type' => 'post', 'posts_per_page' => esc_attr( $count ) );
	$blog_query = new WP_Query($blog_args);
	
	if (!empty($id)): $output .= '<div id="'. esc_attr( $id ) .'" class="blog-3col-grid">';
	
	else: $output .= '<div class="blog-3col-grid">';
	
	endif;	
	
	$output .= '<div class="row">';
 
	if ($blog_query -> have_posts()) : while ($blog_query -> have_posts()) : $blog_query -> the_post();
	
	$output .= '<div class="col-lg-4">';
	$output .= '<article class="blog-item blog-item-3col-grid">';
	
	if ( has_post_thumbnail( get_the_ID() ) ):
	
	$output .= '<div class="post-image"><a href="'. get_permalink() .'">'. get_the_post_thumbnail( get_the_ID(), 'atis-image700x700', array( 'class' => 'img-fluid' )) .'</a></div>';

	endif;

	$output .= '<div class="post-holder">';
	
	$output .= '<div class="meta-info">';
	$output .= '<div class="meta-date-all">'. get_the_date(get_option('date_format')) .'</div>';
	$output .= '<div class="meta-categ-all">';
	
	$categories = get_the_category();
	
	if(!empty($categories)):
	
	foreach( $categories as $category ):
	
	$output .= ' <a href="' . get_category_link( $category->term_id ) . '">'. $category->name .'</a>';
	
	endforeach;
		
	endif;	
	
	$output .= '</div></div>';
   
	$output .= '<h2 class="article-title display-5"><a href="'. get_permalink() .'">'. get_the_title() .'</a></h2><div class="article-excerpt">'. wp_trim_words( get_the_excerpt(), 20, ' ...' ) .'</div>';

	$output .= '<a class="post-more" href="'. get_permalink() .'">' . esc_html__('Read More &rarr;', 'atis') .'</a>';
	$output .= '</div></article></div>';
	
	endwhile;
	endif; wp_reset_postdata();
	
	$output .= '</div></div>';

return $output;

}

add_shortcode( 'blog_3cols', 'atis_shortcode_blog_3cols' );