<?php get_header(); ?>
<?php if( get_option('page_for_posts') == '0'): $image = ''; 
		else:
		$image = wp_get_attachment_image_src( get_post_thumbnail_id( get_option('page_for_posts') ), 'full' );
	endif;
 ?>

<div class="top-single-bkg top-archive" <?php if(!empty($image)):?> style="background-image:url('<?php echo esc_url($image[0]); ?>');" <?php endif;?>>
	
	<div class="inner-desc">
		<div class="container">
		<?php $post = $posts[0]; // Hack. Set $post so that the_date() works. ?>
		<?php /* If this is a category archive */ if (is_category()) { ?>
		<span class="post-subtitle"><?php esc_html_e('Browsing Category', 'atis')?></span>
		<h1 class="display-3 single-post-title"> <?php single_cat_title(); ?> </h1>
		<?php /* If this is a tag archive */ } elseif( is_tag() ) { ?>
		<span class="post-subtitle"><?php esc_html_e('Browsing Tag', 'atis')?></span>
		<h1 class="display-2 single-post-title"> &#8216;<?php single_tag_title(); ?>&#8217; </h1>
		<?php /* If this is a daily archive */ } elseif (is_day()) { ?>
		<span class="post-subtitle"><?php esc_html_e('Browsing Archives', 'atis')?></span>
		<h1 class="display-2 single-post-title"> <?php echo get_the_date(get_option('date_format')); ?> </h1>
		<?php /* If this is a monthly archive */ } elseif (is_month()) { ?>
		<span class="post-subtitle"><?php esc_html_e('Browsing Archives', 'atis')?></span>
		<h1 class="display-2 single-post-title"> <?php echo get_the_date('M, Y'); ?> </h1>
		<?php /* If this is a yearly archive */ } elseif (is_year()) { ?>
		<span class="post-subtitle"><?php esc_html_e('Browsing Archives', 'atis')?></span>
		<h1 class="display-2 single-post-title"> <?php echo get_the_date('Y'); ?> </h1>
		<?php /* If this is an author archive */ } elseif (is_author()) { ?>
		<h1 class="display-2 single-post-title"> <?php esc_html_e('Author Archive', 'atis')?> </h1>
		<?php /* If this is a paged archive */ } elseif (isset($_GET['paged']) && !empty($_GET['paged'])) { ?>
		<h1 class="display-2 single-post-title"> <?php esc_html_e('Blog Archives', 'atis')?> </h1>
		<?php } ?>
		</div>
	</div>
	
</div>

<?php $match_sidebar = get_theme_mod( 'match_sidebar', 'match_sidebar_right'); ?>
<div class="container blog-holder">
<div class="row">
	<?php if ( is_active_sidebar( 'sidebar-1' ) && ( $match_sidebar != 'match_sidebar_no') ): ?>
	<div class="col-md-9 <?php if ( $match_sidebar == 'match_sidebar_left' ): ?> posts-holder-push-right <?php else: ?> posts-holder post-sidebar <?php endif; ?>">
		<?php else: ?>
		<div class="col-md-12 posts-fullwidth">
			<?php endif; ?>
			<?php
				$match_home_articles_layout = get_theme_mod( 'match_home_articles_layout', 'match_home_articles_layout_1col');
				
					switch ($match_home_articles_layout) {
					
					case 'match_home_articles_layout_1col':
				        get_template_part('include/assets/layouts/layout', '1col');
				        break;
					case 'match_home_articles_layout_2col_grid':
				        get_template_part('include/assets/layouts/layout', '2col_grid');
				        break;
					case 'match_home_articles_layout_3col_grid':
				        get_template_part('include/assets/layouts/layout', '3col_grid');
				        break;	
					case 'match_home_articles_layout_1col_list_left':
				        get_template_part('include/assets/layouts/layout', '1col_list_left');
				        break;			
							
						
					default:
				         get_template_part('include/assets/layouts/layout', '1col');
				}
				
				?>
		</div>
		<?php  if ( is_active_sidebar( 'sidebar-1' ) && ( $match_sidebar != 'match_sidebar_no' ) ): ?>
		<?php get_sidebar(); ?>
		<?php endif; ?>
	</div>
	<!--row-->
</div>
<!--container-->
<?php get_footer(); ?>