<?php
	if ( ! function_exists( 'atis_setup' ) ) :
	
	function atis_setup() {
		
		load_theme_textdomain('atis', get_theme_file_path() . '/languages');
		add_theme_support( 'automatic-feed-links' );
		add_theme_support( 'title-tag' );	
		
		// Register Post Thumbnail
		add_theme_support( 'post-thumbnails' );
		set_post_thumbnail_size(700,700,true);
		add_image_size( 'atis-image700x700', 700, 700, true );
		add_image_size( 'atis-image700x500', 700, 500, true );
		add_image_size( 'atis-image700x0', 700, 0 ); // for masonry layout
	
		register_nav_menus(	array(
				'primary-menu' => esc_html__( 'Primary Menu', 'atis'),
			)
		);
		
		/*
		 * Switch default core markup for search form, comment form, and comments
		 * to output valid HTML5.
		 */
		add_theme_support( 'html5', array(
			'search-form',
			'comment-form',
			'comment-list',
			'gallery',
			'caption',
		) );	
		
		// Set up the WordPress core custom background feature
		add_theme_support( 'custom-background', apply_filters( 'atis_custom_background_args', array(
			'default-color' => 'ffffff',
			'default-image' => '',
		) ) );
		
		// Add theme support for selective refresh for widgets
		add_theme_support( 'customize-selective-refresh-widgets' );
		
		// Add support for core custom logo
		add_theme_support( 'custom-logo', array(
			'height'      => 150,
			'width'       => 250,
			'flex-width'  => true,
			'flex-height' => true,
		) );
		
		// Add support for full and wide align images.
	add_theme_support( 'align-wide' );
	
	// Add support for Block Styles.
	add_theme_support( 'wp-block-styles' );
	
	// Add support for responsive embedded content.
	add_theme_support( 'responsive-embeds' );
	
	// Add support for custom header
	add_theme_support( 'custom-header' );
	
	// Add support for editor styles.
	add_theme_support( 'editor-styles' );

	// Enqueue editor styles.
	add_editor_style( 'css/style-editor.css' );
		
	}
	endif;
	
	add_action( 'after_setup_theme', 'atis_setup' );
	
	function atis_content_width() {
		$GLOBALS['content_width'] = apply_filters( 'atis_content_width', 1170 );
	}
	add_action( 'after_setup_theme', 'atis_content_width', 0 );
	
	// 1. Hide ACF field group menu item
	add_filter('acf/settings/show_admin', '__return_false');
	
	// 2. Include ACF
	include_once( get_theme_file_path('/include/theme-settings.php') );	
	
	/* TGM Plugin Activation */
	include_once ( get_theme_file_path('/include/tgm-plugin/plugin-install.php') );
	
	// Add Theme Live Customizer options
	include_once ( get_theme_file_path('/include/customizer/kirki/kirki.php') );
	include_once ( get_theme_file_path('/include/customizer/customizer-options.php') );
	include_once ( get_theme_file_path('/include/customizer/customizer-live.php') );
	
	//Fixed Top Header
	include_once ( get_theme_file_path('/include/header-sticky.php') );
	
	//Add Google Web Fonts
	
	if( !function_exists( 'atis_fonts_url' ) ) {
	
	function atis_fonts_url() {
	    $font_url = '';
		
		$match_body_font = get_theme_mod( 'match_body_font', 'Work Sans');
		$match_body_font_weight = get_theme_mod( 'match_body_font_weight', '400,400i,500,600,700,700i');
		$match_titles_font = get_theme_mod( 'match_titles_font', 'Crimson Text');
		$match_titles_font_weight = get_theme_mod( 'match_titles_font_weight', '400,400i,600,600i,700,700i');
	    
	    /*
	    Translators: If there are characters in your language that are not supported
	    by chosen font(s), translate this to 'off'. Do not translate into your own language.
	     */
	    if ( 'off' !== _x( 'on', 'Google font: on or off', 'atis' ) ) {
		
		if ( $match_body_font != $match_titles_font ){
		
		 $font_url = add_query_arg( 'family', urlencode( $match_body_font.':'.$match_body_font_weight.'|'.$match_titles_font.':'.$match_titles_font_weight.'&display=swap'), "//fonts.googleapis.com/css" );
		
		}
		
		else{ $font_url = add_query_arg( 'family', urlencode( $match_body_font.':'.$match_body_font_weight.'&display=swap'), "//fonts.googleapis.com/css" );
		}
			
	    }
	    return $font_url;
	}
	
	}
	
	if( !function_exists( 'atis_fonts_script' ) ) {
	
	function atis_fonts_script() {
	
	    wp_enqueue_style( 'atis-fonts', atis_fonts_url(), array(), null );
		
	}
	add_action( 'wp_enqueue_scripts', 'atis_fonts_script' );
	
	}
	
	/**
	* Enqueue editor styles for Gutenberg
	*/
	 
	function atis_editor_styles() {
		wp_enqueue_style('fontawesome', get_theme_file_uri('/css/fontawesome/css/fontawesome.css'), array(), null);
		wp_enqueue_style( 'atis-fonts', atis_fonts_url(), array(), null );
	}
	add_action( 'enqueue_block_editor_assets', 'atis_editor_styles' );
	
	
	//	Register and load front end JS and CSS files
	if( !function_exists( 'atis_scripts_init' ) ) {
	    function atis_scripts_init() {
		
			wp_enqueue_style('bootstrap', get_theme_file_uri('/css/bootstrap/css/bootstrap.css'), array(), null);
			wp_enqueue_style('fontawesome', get_theme_file_uri('/css/fontawesome/css/fontawesome.css'), array(), null);
			wp_enqueue_style('owl-carousel', get_theme_file_uri('/js/owl-carousel/owl.carousel.css'), array(), null);
			wp_enqueue_style('atis-style', get_parent_theme_file_uri('/style.css'), array(), null);	
			wp_enqueue_script('easing', get_theme_file_uri('/js/easing.js'), array( 'jquery' ),null,true);
			wp_enqueue_script('owl-carousel', get_theme_file_uri('/js/owl-carousel/owl.carousel.js'), array( 'jquery' ),null,true);
			wp_enqueue_script('simple-lightbox', get_theme_file_uri('/js/simple-lightbox.js'), array( 'jquery' ),null,true);
			wp_enqueue_script('isotope', get_theme_file_uri('/js/isotope.js'), array( 'jquery' ),null,true);
			wp_enqueue_script('atis-init', get_theme_file_uri('/js/init.js'), array( 'jquery' ),null,true);
			
			
			if( is_single() ){
	  			
				wp_enqueue_script('atis-commentform', get_theme_file_uri('/js/commentform.js'), array( 'jquery', 'jquery-form' ),null,true);
				
				$translation_array = array( 'name_error' => esc_html__( 'Please fill the Name field!', 'atis' ),
										'email_error' => esc_html__( 'Please fill the Email field!', 'atis' ),
										'emailvalid_error' => esc_html__( 'Please provide a valid Email address!', 'atis' ),
										'message_error' => esc_html__( 'Please fill the Message field!', 'atis' ),
										'send_msg' => esc_html__( 'Posting comment...!', 'atis' ),
										'msg_sent' => esc_html__( 'Comment posted', 'atis' )
										 );
										 
			wp_localize_script( 'atis-commentform', 'commFobject', $translation_array );
				
			}
			
		}
			
	    
	    add_action('wp_enqueue_scripts', 'atis_scripts_init', 98);
	}
	
	function atis_comments_reply() {
		
		if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
			wp_enqueue_script( 'comment-reply' );
		}
	}
	
	add_action( 'comment_form_before', 'atis_comments_reply' );
	
	
	// Register Sidebars
	
	function atis_widgets_init() {
		
		//main sidebar
		register_sidebar(array(
			'id' => 'sidebar-1',
			'name' => esc_html__( 'Sidebar','atis'),
			'description' => esc_html__( 'Main sidebar that appears on a normal page.','atis' ),
			'before_widget' => '<li id="%1$s" class="widget %2$s">',
			'after_widget' => '</li>',
			'before_title' => '<h5 class="widgettitle">',
			'after_title' => '</h5>'
		));
		
		//footer 1
		register_sidebar(array(
			'name' => esc_html__( 'Footer 1','atis'),
			'id' => 'footer-one',
			'description' => esc_html__( 'Widgets in this area are used in the first footer column','atis' ),
			'before_widget' => '<div id="%1$s" class="widget widget-footer %2$s">',
			'after_widget' => '</div>',
			'before_title' => '<h5 class="widgettitle">',
			'after_title' => '</h5>'
		));
		
		//footer 2
		register_sidebar(array(
			'name' => esc_html__( 'Footer 2','atis'),
			'id' => 'footer-two',
			'description' => esc_html__( 'Widgets in this area are used in the second footer column','atis' ),
			'before_widget' => '<div id="%1$s" class="widget widget-footer %2$s">',
			'after_widget' => '</div>',
			'before_title' => '<h5 class="widgettitle">',
			'after_title' => '</h5>'
		));
		
		//footer 3
		register_sidebar(array(
			'name' => esc_html__( 'Footer 3','atis'),
			'id' => 'footer-three',
			'description' => esc_html__( 'Widgets in this area are used in the third footer column','atis' ),
			'before_widget' => '<div id="%1$s" class="widget widget-footer %2$s">',
			'after_widget' => '</div>',
			'before_title' => '<h5 class="widgettitle">',
			'after_title' => '</h5>'
		));
		
		//footer 4
		register_sidebar(array(
			'name' => esc_html__( 'Footer 4','atis'),
			'id' => 'footer-four',
			'description' => esc_html__( 'Widgets in this area are used in the forth footer column','atis' ),
			'before_widget' => '<div id="%1$s" class="widget widget-footer %2$s">',
			'after_widget' => '</div>',
			'before_title' => '<h5 class="widgettitle">',
			'after_title' => '</h5>'
		));
		
	}
	add_action( 'widgets_init', 'atis_widgets_init' );
	
	// Excerpt Content
	function atis_excerpt_length( $length ) {
		return 40;
	}
	add_filter( 'excerpt_length', 'atis_excerpt_length');
	
	function atis_excerpt_more( $more ) {
		return '...';
	}
	add_filter('excerpt_more', 'atis_excerpt_more');
	
	
	// Add Custom Image Size to Media
	
	function atis_custom_image_sizes( $sizes ) {
	
		$imgSizes = array(
			'atis-image700x700' => esc_html__('Custom Size 700x700', 'atis'),
	    );
		
		$imgSizes = array(
			'atis-image700x500' => esc_html__('Custom Size 700x500', 'atis'),
	    );
		
		$sizes = array_merge( $sizes,  $imgSizes );
	
	    return $sizes;
	}
	
	add_filter( 'image_size_names_choose', 'atis_custom_image_sizes' );
	
	//page navigation
	function atis_pagenavi( $p = 2 ) { // pages will be show before and after current page
	  if ( is_singular() ) return; // don't show in single page
	  global $wp_query, $paged;
	  $max_page = $wp_query->max_num_pages;
	  
	  if ( $max_page == 1 ) return; // don't show when only one page
	  if ( empty( $paged ) ) $paged = 1;
	  echo '<div class="prev-next">';
	  echo '<span class="nav-page">';
	  previous_posts_link(esc_html__('&lt;', 'atis'));
	  echo '</span>';
	  if ( $paged > $p + 1 ) atis_p_link( 1 );
	  if ( $paged > $p + 2 ) echo '<span class="more-pages">...</span>';
	  for( $i = $paged - $p; $i <= $paged + $p; $i++ ) { // Middle pages
	    if ( $i > 0 && $i <= $max_page ) $i == $paged ? print "<span class='page-numbers current-page'>{$i}</span> " : atis_p_link( $i );
	  }
	  if ( $paged < $max_page - $p - 1 ) echo '<span class="more-pages">...</span>';
	  if ( $paged < $max_page - $p ) atis_p_link( $max_page );
	  echo '<span class="nav-page">';
	  next_posts_link(esc_html__('&gt;', 'atis'));
	  echo '</span>';
	  echo '</div><!--end-->';
	}
	function atis_p_link( $i ) {
	  echo "<a class='page-numbers' href='", esc_html( get_pagenum_link( $i ) ), "'>{$i}</a> ";
	}
	
	//create new comments output
	function atis_custom_comments($comment, $args, $depth) {
		$GLOBALS['comment'] = $comment;
	?>
<li <?php comment_class(); ?> id="li-comment-<?php comment_ID() ?>">
	<div id="comment-<?php comment_ID(); ?>" class="comment-body <?php if ($comment->comment_approved == '0') echo 'pending-comment'; ?> clearfix">
		<div class="comment-details">
			<div class="comment-avatar">
				<?php echo get_avatar($comment, $size = '70'); ?>
			</div>
			<!-- /comment-avatar -->
			<div class="comment-right">
				<section class="comment-author vcard">
					<span class="comment-date"> <?php echo get_comment_date(); ?></span>
					<h4 class="author"><?php echo get_comment_author_link()?></h4>
				</section>
				<!-- /comment-meta -->
				<section class="comment-content">
					<div class="comment-text">
						<?php comment_text() ?>
					</div>
					<!-- /comment-text -->
					<div class="reply">
						<?php comment_reply_link(array_merge( $args, array('reply_text' => esc_html__('Reply','atis'),'depth' => $depth, 'max_depth' => $args['max_depth']))) ?>
					</div>
					<!-- /reply -->
				</section>
				<!-- /comment-content -->
			</div>
			<!-- /comment-right -->
		</div>
		<!-- /comment-details -->
	</div>
	<!-- /comment -->
	<?php
	} //end custom_comments()

	
	/**
*
* Add body class to pages without featured image
*
*/

function atis_add_body_class_no_featured_image( $classes ) {
  if((is_single() && !has_post_thumbnail()) || (is_page() && !has_post_thumbnail()) || ( is_home() && !has_post_thumbnail( get_option( 'page_for_posts' ) ) ) || (is_front_page() && !has_post_thumbnail() ) || (is_archive() && get_option('page_for_posts') == '0') || (is_search() && get_option('page_for_posts') == '0') ) {
    $classes[] = 'no-top-image';
  }
  return $classes;
}
add_filter( 'body_class','atis_add_body_class_no_featured_image' );

//remove Elementor Font Awesome
	add_action( 'elementor/frontend/after_register_styles',function() {
	foreach( [ 'solid', 'regular', 'brands' ] as $style ) {
		wp_deregister_style( 'elementor-icons-fa-' . $style );
	}
	}, 20 );
	
//remove Elementor Roboto fonts
add_filter( 'elementor/frontend/print_google_fonts', '__return_false' );	