<?php $match_sidebar = get_theme_mod( 'match_sidebar', 'match_sidebar_right'); ?>
<section id="wrap-content" class="blog-1col-list-left <?php if ( (!is_active_sidebar( 'sidebar-1' )) || ( $match_sidebar == 'match_sidebar_no' )): ?> layout-1col-fw <?php endif;?>">

<?php if (have_posts()) : while (have_posts()) : the_post(); 
	
    $classes_post = array('blog-item','blog-item-1col-list');
		
?>

<article id="post-<?php the_ID(); ?>" <?php post_class($classes_post); ?> >

<?php $image = wp_get_attachment_image_src( get_post_thumbnail_id( $post->ID ), 'atis-image700x700' ); ?>

<?php if(!empty($image)): ?>

<div class="post-image">
<a href="<?php the_permalink();?>">
<div class="list-image" style="background-image:url('<?php echo esc_url($image[0]); ?>');"></div>
</a>
</div><!--post-image-->

<?php endif; ?>

<div class="post-holder <?php if(empty($image)):?> post-holder-noimg <?php endif; ?>">

<div class="list-holder">

	<div class="meta-info">
   <div class="meta-date-all"><?php echo get_the_date(get_option('date_format')); ?></div>
   <div class="meta-categ-all"><?php the_category(' '); ?>
   <?php if ( is_sticky() && is_home() ) : ?>
    <span class="meta-sticky"><?php esc_html_e('Featured', 'atis'); ?></span>
    <?php endif; ?>
	</div>
   </div>
   
	<h2 class="article-title display-5"><a href="<?php the_permalink() ?>"><?php the_title(); ?></a></h2>
	
	 <div class="article-excerpt">
          <?php echo wp_trim_words( get_the_excerpt(), 25, ' ...' ); ?>
      </div>
   
    <a class="post-more" href="<?php the_permalink() ?>"><?php esc_html_e('Read More', 'atis'); ?></a>

	  </div>
</div><!--post holder-->

</article>

<?php endwhile;

else: ?>

<div class="row">

<div class="col-md-12 alignc nothing-found">

<h2><?php esc_html_e( 'NOTHING FOUND', 'atis' ); ?></h2>

<div class="nf-text"><?php esc_html_e( 'Sorry, but it seems we can&rsquo;t find what you&rsquo;re looking for. Try a new search or the menu above.', 'atis' ); ?></div>

<?php get_search_form(); ?>

</div>

</div>

<?php endif; ?>

<?php

 if(function_exists('atis_pagenavi') ) : ?>

	<?php atis_pagenavi();  ?>
       
	<?php else : ?>

  <ul class="other-entries">
			<li class="newer-entries"><span><?php previous_posts_link(esc_html__('&larr; Prev', 'atis')) ?></span></li>
            <li class="older-entries"><span><?php next_posts_link(esc_html__('Next &rarr;', 'atis')) ?></span></li>
          </ul>
      
<?php endif; ?>

</section><!--blog-1col-->