<?php 

if ( ! function_exists( 'atis_customizer_css' ) ) :

function atis_customizer_css() {

	$custom_css = '';
	$body_styles = '';
	
	// start body

	$match_body_font = get_theme_mod( 'match_body_font', 'Work Sans');
	$match_body_font_size = get_theme_mod( 'match_body_font_size');
	$match_body_text_color = get_theme_mod( 'match_body_text_color');
	
	$body_styles .= 'font-family: ' . $match_body_font . ', sans-serif;';
	
	if( !empty($match_body_font_size) ) { $body_styles .= 'font-size: ' . $match_body_font_size . 'px;'; }
	if( !empty($match_body_text_color) ) { $body_styles .= 'color: ' . $match_body_text_color . ';';
	
	 }
		
	$body_styles = 'body{' .$body_styles. '}';
	
	$custom_css .= $body_styles;
	
	// post titles
	
	$match_titles_font = get_theme_mod( 'match_titles_font', 'Crimson Text');
	$custom_css .= 'h1, h2, h3, h4, h5, h6, blockquote, .logo-txt, .wp-block-latest-comments__comment-author, .wp-block-latest-comments__comment-link{ font-family:'.$match_titles_font.', serif; }';
	
	// link color
	
	$match_link_color = get_theme_mod( 'match_link_color');
	
	if (!empty($match_link_color)){ 
	
		$custom_css .= 'a, .pcolor, a:hover, p a:hover, .pcolor .elementor-heading-title, blockquote cite, .menu-contact i, .footer-contact i, .social-media-footer li a, .about-social i, .binfo ul li i, .header-social-2 .social-media li a, .practice-subtitle, .icon-top i, .practice-icon-wrap h3 a:hover, .practice-image-wrap h3 a:hover, .team-wrap-v1 h3 a:hover, .practice-v2-more .post-more, .team-social .social-media li a, .team-social-v2 .social-media li a, .team-wrap-v2 h3 a:hover, .section-contact i, .section-contact a:hover, .case-wrap h3 a:hover, .article-title a:hover, .meta-categ-all a, .meta-sticky, .post-more:hover, .post-meta li a:hover, .author-single-page h3 a:hover, .meta-nav a:hover, .comment-author .author a:hover, .comment-reply-link:hover, .display-post-title a:hover, .widget_recent_entries li a:hover, .widget_archive li a:hover, .widget_categories li a:hover, .widget_pages li a:hover, .widget_meta li a:hover, .widget_nav_menu li a:hover, .pcolori .elementor-icon, .el-tab .elementor-tab-title a:hover, .el-tab .elementor-tab-title.elementor-active a, .el-tab .elementor-tab-title:hover, .el-tab .elementor-tab-title.elementor-active, .elementor-accordion .elementor-tab-title .elementor-accordion-icon, .elementor-toggle .elementor-tab-title .elementor-toggle-icon, .price-title, .elementor-social-icon:hover i, .wp-block-latest-posts li a, .wp-block-categories li a, .wp-block-archives li a, .wp-block-latest-posts li a:hover, .wp-block-categories li a:hover, .wp-block-archives li a:hover, .wp-block-button.is-style-outline .wp-block-button__link, .wp-block-button__link:not(.has-background):active, .wp-block-button__link:not(.has-background):focus, .list-items li:before{color:'.$match_link_color.';}';
		$custom_css .= '.pcolor-bkg, .list-circle li:before, blockquote:before, .smalltitle span:after, .meta-sticky, .tagcloud a:hover, .tags-single-page a:hover, .foo-block .tagcloud a:hover, .read-more, #submit, .submit, .wpcf7-submit, .page-links a, .post-password-form input[type="submit"], .el-btn .elementor-button, .current-page, .page-numbers:hover, .nav-page a:hover, .scrollup i, .alert, .owl-theme .owl-dots .owl-dot span, .owl-theme .owl-dots .owl-dot.active span, .owl-theme .owl-dots .owl-dot:hover span, .pcolor-circle .elementor-icon, .pcolor-circle30 .elementor-icon, .wp-block-button .wp-block-button__link, .meta-categ-all a:after, .icon-bkg .elementor-icon{ background: '.$match_link_color.';}';
		$custom_css .= '.smallborder span, .post-more, .comment-reply-link, .elementor-toggle .elementor-tab-title.elementor-active, .wp-block-quote.has-text-align-right{ border-color:'.$match_link_color.'; }';
		$custom_css .= '.list-practice li a:hover, .list-practice li.practice-active a, .elementor-accordion .elementor-tab-title:hover, .elementor-accordion .elementor-tab-title.elementor-active, .elementor-toggle .elementor-tab-title:hover, .elementor-toggle .elementor-tab-title.elementor-active{ border-color:'.$match_link_color.'; background: '.$match_link_color.'; }';
		$custom_css .= '.icon-circle .elementor-icon{ border-color:'.$match_link_color.'; color: '.$match_link_color.'; }';
		$custom_css .= '.pcolori svg path, .testimonial-quote svg.icon{ fill:'.$match_link_color.';}';		
		
	}
	
	// heavy color
	$match_heavy_color = get_theme_mod( 'match_heavy_color');
	
	if (!empty($match_heavy_color)){
	
	$custom_css .= 'h1, h2, h3, h4, h5, h6, pre, code, blockquote, .topnoimg .single-post-title, .topnoimg .post-subtitle, .page-title-above .single-post-title, .page-title-above .post-subtitle, .practice-icon-wrap h3 a, .practice-image-wrap h3 a, .team-wrap-v1 h3 a, .list-practice li a, .section-contact a, .testimonial-desc, .testimonial-client, .meta-date-all, .post-more, .author-single-page h3 a, .meta-nav a, .comment-author .author, .comment-author .author a, .comment-author span.comment-date, .comment-reply-link, .foo-block .tagcloud a, .display-post-title a, .widget_recent_entries li a, .widget_archive li a, .widget_categories li a, .widget_pages li a, .widget_meta li a, .widget_nav_menu li a, .comm-field, .contact-field, #msg-contact, .wpcf7-text, .wpcf7-textarea, .read-more.white-btn:hover, .el-btn.white-btn .elementor-button.elementor-size-md:hover, .el-btn.white-btn .elementor-button.elementor-size-sm:hover, .scrollup i, .alert, .el-tab .elementor-tab-title a, .el-tab .elementor-tab-title, .elementor-accordion .elementor-tab-title, .elementor-toggle .elementor-tab-title, .wp-block-button.is-style-outline .wp-block-button__link:hover, .wp-block-latest-comments__comment-meta a, .wp-block-latest-comments__comment-date, .case-wrap h3 a, .article-title a{color:'.$match_heavy_color.';}';
	$custom_css .= '.search-string, .wp-block-search .wp-block-search__input{ border-color:'.$match_heavy_color.'; color: '.$match_heavy_color.'; }';		
	$custom_css .= '.foo-block .search-string{ border-color:'.$match_heavy_color.';}';	
	$custom_css .= '.tagcloud a, .tags-single-page a, .read-more:hover, #submit:hover, .submit:hover, .wpcf7-submit:hover, .page-links a:hover, .post-password-form input[type="submit"]:hover, .el-btn .elementor-button.elementor-size-md:hover, .el-btn .elementor-button.elementor-size-sm:hover, .page-numbers, .nav-page a, .wp-block-button .wp-block-button__link:hover, .wp-block-search__button:hover{ background:'.$match_heavy_color.';}';		
	
	}
	
	// headings size
	$match_h1_size = get_theme_mod( 'match_h1_size');
	if (!empty($match_h1_size)){ $custom_css .= 'h1{font-size:'.$match_h1_size.'px;}'; }
	
	$match_h2_size = get_theme_mod( 'match_h2_size');
	if (!empty($match_h2_size)){ $custom_css .= 'h2{font-size:'.$match_h2_size.'px;}'; }
	
	$match_h3_size = get_theme_mod( 'match_h3_size');
	if (!empty($match_h3_size)){ $custom_css .= 'h3{font-size:'.$match_h3_size.'px;}'; }
	
	$match_h4_size = get_theme_mod( 'match_h4_size');
	if (!empty($match_h4_size)){ $custom_css .= 'h4{font-size:'.$match_h4_size.'px;}'; }
	
	$match_h5_size = get_theme_mod( 'match_h5_size');
	if (!empty($match_h5_size)){ $custom_css .= 'h5{font-size:'.$match_h5_size.'px;}'; }
	
	$match_h6_size = get_theme_mod( 'match_h6_size');
	if (!empty($match_h6_size)){ $custom_css .= 'h6{font-size:'.$match_h6_size.'px;}'; }
	
	// menu colors
	
	$match_menu_normal_color = get_theme_mod( 'match_menu_normal_color');
	if (!empty($match_menu_normal_color)){

	$custom_css .= '.menu-nav li a, .menu-mobile li a{color:'.$match_menu_normal_color.';}';
	
	}
	
	$match_menu_hover_color = get_theme_mod( 'match_menu_hover_color');
	if (!empty($match_menu_hover_color)){
		
	$custom_css .= '.menu-nav li a:hover, .menu-nav > li:hover > a, .menu-nav > li.current-menu-item > a, .menu-mobile li:hover > a, .menu-mobile li.current-menu-item > a{color:'.$match_menu_hover_color.';}';
		
	}
	
	$match_submenu_bkg_color = get_theme_mod( 'match_submenu_bkg_color');
	 if (!empty($match_submenu_bkg_color)){

	$custom_css .= '.menu-nav ul {background:'.$match_submenu_bkg_color.';}';

	 }
	 
	 $match_submenu_normal_color = get_theme_mod( 'match_submenu_normal_color');
	 if (!empty($match_submenu_normal_color)){

	$custom_css .= '.menu-nav ul li > a{color:'.$match_submenu_normal_color.';}';
	
	 }
	 
	  $match_submenu_hover_color = get_theme_mod( 'match_submenu_hover_color');
	 if (!empty($match_submenu_hover_color)){  
	 
	 $custom_css .= '.menu-nav ul li a:hover, .menu-nav li:hover ul li a:hover{color:'.$match_submenu_hover_color.';}';
	 
	 }
	 
	// footer colors
	$match_footer_bkg_color = get_theme_mod( 'match_footer_bkg_color');
	if (!empty($match_footer_bkg_color)){ $custom_css .= 'footer{background:'.$match_footer_bkg_color.';}'; }
	
	$match_footer_txt_color = get_theme_mod( 'match_footer_txt_color');
	if (!empty($match_footer_txt_color)){ $custom_css .= 'footer, footer a, .footer-social li a{color:'.$match_footer_txt_color.';}'; }
	
	$custom_css .= '.practice-image-wrap-v2 h3 a {color: #ffffff;}';
		 
	 if ( is_admin_bar_showing() ) { $custom_css .= '.main-header, .header-holder.nav-fixed-top{top:32px;}'; }
	
	wp_add_inline_style( 'atis-style', $custom_css );
	
}

endif;
	
add_action( 'wp_enqueue_scripts', 'atis_customizer_css', 99);
?>