<?php
/**
* The configuration options
*/

if ( class_exists( 'Kirki' ) ):

	/**
	 * Add sections
	 */
	 
	 Kirki::add_section( 'match_headers', array(
		'title'          => esc_attr__( 'Headers', 'atis' ),
		'priority'       => 50,
		'capability'     => 'edit_theme_options',
	) );
	
	Kirki::add_section( 'match_general', array(
		'title'          => esc_attr__( 'General Options', 'atis' ),
		'priority'       => 52,
		'capability'     => 'edit_theme_options',
	) );
	
	Kirki::add_section( 'match_typography_options', array(
		'title'          => esc_attr__( 'Typography', 'atis' ),
		'priority'       => 53,
		'capability'     => 'edit_theme_options',
	) );
	
	Kirki::add_section( 'match_social_media', array(
		'title'          => esc_attr__( 'Social Media', 'atis' ),
		'priority'       => 54,
		'capability'     => 'edit_theme_options',
	) );	
	
	 
/**
	 * Add the configuration.
	 * This way all the fields using the 'match_fields' ID
	 * will inherit these options
	 */
	Kirki::add_config( 'match_fields', array(
		'capability'    => 'edit_theme_options',
		'option_type'   => 'theme_mod',
	) );

	
	//Headers
	
	Kirki::add_field( 'match_fields', array(
	'type'        => 'radio',
	'settings'    => 'match_header_display',
	'label'       => esc_attr__( 'Top Header Display', 'atis' ),
	'section'     => 'match_headers',
	'default'     => 'match_header1',
	'choices'     => array(
		'match_header1'   => esc_attr__( 'Top Header 1', 'atis' ),
		'match_header2' => esc_attr__( 'Top Header 2', 'atis' ),
		'match_header3'  => esc_attr__( 'Top Header 3', 'atis' ),
		'match_header4'  => esc_attr__( 'Top Header 4', 'atis' ),
		'match_header5'  => esc_attr__( 'Top Header 5', 'atis' ),
	),
) );

	Kirki::add_field( 'match_fields', array(
	'type'        => 'switch',
	'settings'    => 'match_header_fixed',
	'label'       => esc_attr__( 'Fixed Top Header', 'atis' ),
	'section'     => 'match_headers',
	'default'     => 'off',
	'choices'     => array(
		'on'  => esc_attr__( 'On', 'atis' ),
		'off' => esc_attr__( 'Off', 'atis' ),
	),
) );

	Kirki::add_field( 'mt_fields', array(
		'type'        => 'textarea',
		'settings'    => 'match_header_btn',
		'label'       => esc_attr__( 'Header Button', 'atis' ),
		'default'     => '',
		'section'     => 'match_headers',
		'description' => esc_attr__( 'Add header button', 'atis' ),
	) );

	Kirki::add_field( 'match_fields', array(
		'type'        => 'textarea',
		'settings'    => 'match_mobile_info',
		'label'       => esc_attr__( 'Header Business Info Top & Mobile', 'atis' ),
		'default'     => '',
		'section'     => 'match_headers',
		'description' => esc_attr__( 'Add header business info on top and mobile', 'atis' ),
	) );

	// general options
	
	Kirki::add_field( 'match_fields', array(
	'type'        => 'radio',
	'settings'    => 'match_home_top',
	'label'       => esc_attr__( 'Home - Slider or Video', 'atis' ),
	'section'     => 'match_general',
	'default'     => 'match_home_top_slider',
	'choices'     => array(
		'match_home_top_slider'   => esc_attr__( 'Slider', 'atis' ),
		'match_home_top_video' => esc_attr__( 'Video', 'atis' ),
	),
) );
	
	Kirki::add_field( 'match_fields', array(
	'type'        => 'repeater',
	'label'       => esc_attr__( 'Home - Slider Items', 'atis' ),
	'section'     => 'match_general',
	'description' => esc_attr__( 'Create home top slider. Add as much items as you want', 'atis' ),
	'row_label' => array(
		'type' => 'text',
		'value' => esc_attr__('Slider Item', 'atis' ),
	),
	'settings'    => 'match_slides',
	'default'     => '',
	'fields' => array(
		'match_slide_text' => array(
			'type'        => 'textarea',
			'label'       => esc_attr__( 'Slider Text', 'atis' ),
			'description' => esc_attr__( 'Add slider text', 'atis' ),
			'default'     => '',
		),
		'match_slide_image' => array(
			'type'        => 'image',
			'label'       => esc_attr__( 'Slider Image', 'atis' ),
			'description' => esc_attr__( 'Upload image file', 'atis' ),
			'default'     => '',
		),
	)
) );

	Kirki::add_field( 'match_fields', array(
		'type'        => 'textarea',
		'settings'    => 'match_video_url',
		'label'       => esc_attr__( 'Home - Video URL', 'atis' ),
		'default'     => '',
		'section'     => 'match_general',
		'description'     => esc_attr__( 'Add home top video URL ( video must be self hosted )', 'atis' ),
	) );
	
	Kirki::add_field( 'match_fields', array(
		'type'        => 'textarea',
		'settings'    => 'match_video_text',
		'label'       => esc_attr__( 'Home - Video Text', 'atis' ),
		'default'     => '',
		'section'     => 'match_general',
		'description'     => esc_attr__( 'Add home top video text', 'atis' ),
	) );
	
	Kirki::add_field( 'match_fields', array(
		'type'        => 'upload',
		'settings'    => 'match_video_img',
		'label'       => esc_attr__( 'Home - Video Image Preloader', 'atis' ),
		'default'     => '',
		'section'     => 'match_general',
		'description'     => esc_attr__( 'Add video image preloader. Useful for slow speed connections.', 'atis' ),
	) );
	
	Kirki::add_field( 'match_fields', array(
		'type'        => 'image',
		'settings'    => 'match_practice_item_top_img',
		'label'       => esc_attr__( 'Practice Item - Single Page Top Image', 'atis' ),
		'default'     => '',
		'description'     => esc_attr__( 'Add top image to the single practice item page', 'atis' ),
		'section'     => 'match_general',
	) );

	Kirki::add_field( 'match_fields', array(
		'type'        => 'image',
		'settings'    => 'match_team_item_top_img',
		'label'       => esc_attr__( 'Team Item - Single Page Top Image', 'atis' ),
		'default'     => '',
		'description'     => esc_attr__( 'Add top image to the single team item page', 'atis' ),
		'section'     => 'match_general',
	) );
	
	Kirki::add_field( 'match_fields', array(
		'type'        => 'image',
		'settings'    => 'match_case_item_top_img',
		'label'       => esc_attr__( 'Case Item - Single Page Top Image', 'atis' ),
		'default'     => '',
		'description'     => esc_attr__( 'Add top image to the single case item page', 'atis' ),
		'section'     => 'match_general',
	) );

	Kirki::add_field( 'match_fields', array(
	'type'        => 'radio-image',
	'settings'    => 'match_home_articles_layout',
	'label'       => esc_attr__( 'Blog - Articles Layout', 'atis' ),
	'section'     => 'match_general',
	'description'     => esc_attr__( 'Select the articles layout for blog page', 'atis' ),
	'default'     => 'match_home_articles_layout_1col',
	'choices'     => array(
		'match_home_articles_layout_1col' => get_template_directory_uri() . '/images/layouts/layout-1col.png',
		'match_home_articles_layout_2col_grid' => get_template_directory_uri() . '/images/layouts/layout-2col.png',
		'match_home_articles_layout_3col_grid' => get_template_directory_uri() . '/images/layouts/layout-3col.png',
		'match_home_articles_layout_1col_list_left' => get_template_directory_uri() . '/images/layouts/layout-1col_list_left.png',
	),
) );

	Kirki::add_field( 'match_fields', array(
	'type'        => 'radio-image',
	'settings'    => 'match_sidebar',
	'label'       => esc_attr__( 'Blog - Sidebar Display', 'atis' ),
	'section'     => 'match_general',
	'description'     => esc_attr__( 'Select how do you want to display the sidebar for home / archive pages ( right / left / none )', 'atis' ),
	'default'     => 'match_sidebar_right',
	'choices'     => array(
		'match_sidebar_right'   => get_template_directory_uri() . '/images/sidebar/sidebar-right.png',
		'match_sidebar_left'   => get_template_directory_uri() . '/images/sidebar/sidebar-left.png',
		'match_sidebar_no'   => get_template_directory_uri() . '/images/sidebar/sidebar-no.png',
	),
) );

	Kirki::add_field( 'match_fields', array(
	'type'        => 'radio-image',
	'settings'    => 'match_sidebar_single',
	'label'       => esc_attr__( 'Single Blog Page - Sidebar Display', 'atis' ),
	'section'     => 'match_general',
	'description'     => esc_attr__( 'Select how do you want to display the sidebar for single blog pages', 'atis' ),
	'default'     => 'match_sidebar_single_right',
	'choices'     => array(
		'match_sidebar_single_right'   => get_template_directory_uri() . '/images/sidebar/sidebar-right.png',
		'match_sidebar_single_left'   => get_template_directory_uri() . '/images/sidebar/sidebar-left.png',
		'match_sidebar_single_no'   => get_template_directory_uri() . '/images/sidebar/sidebar-no.png',
	),
) );

	Kirki::add_field( 'match_fields', array(
	'type'        => 'radio',
	'settings'    => 'match_footer_widgets',
	'label'       => esc_attr__( 'Footer - Widgets Columns', 'atis' ),
	'section'     => 'match_general',
	'default'     => 'match_footer_widgets4',
	'description'     => esc_attr__( 'Select the number of footer columns', 'atis' ),
	'choices'     => array(
		'match_footer_widgets1'   => esc_attr__( 'Footer Column 1', 'atis' ),
		'match_footer_widgets2' => esc_attr__( 'Footer Column 2', 'atis' ),
		'match_footer_widgets3'  => esc_attr__( 'Footer Column 3', 'atis' ),
		'match_footer_widgets4'  => esc_attr__( 'Footer Column 4', 'atis' ),
	),
	) );
	
	Kirki::add_field( 'match_fields', array(
		'type'        => 'image',
		'settings'    => 'match_footer_bkg',
		'label'       => esc_attr__( 'Footer - Background Image', 'atis' ),
		'default'     => '',
		'description'     => esc_attr__( 'Add footer background image', 'atis' ),
		'section'     => 'match_general',
	) );
	
	Kirki::add_field( 'match_fields', array(
		'type'        => 'textarea',
		'settings'    => 'match_footer_copy',
		'label'       => esc_attr__( 'Footer - Copyright', 'atis' ),
		'default'     => '&copy; Atis. Designed by MatchThemes.',
		'section'     => 'match_general',
		'description'     => esc_attr__( 'Add footer copyright', 'atis' ),
	) );
	
	Kirki::add_field( 'match_fields', array(
	'type'        => 'switch',
	'settings'    => 'match_scroll_top',
	'label'       => esc_attr__( 'Scroll Top Button', 'atis' ),
	'section'     => 'match_general',
	'default'     => 'off',
	'description'     => esc_attr__( 'Show/Hide scroll to top button', 'atis' ),
	'choices'     => array(
		'on'  => esc_attr__( 'On', 'atis' ),
		'off' => esc_attr__( 'Off', 'atis' ),
	),
) );

	//colors
	
	Kirki::add_field( 'match_fields', array(
		'type'        => 'color',
		'settings'    => 'match_body_text_color',
		'label'       => esc_attr__( 'Body Text Color', 'atis' ),
		'default'     => '#141c2c',
		'section'     => 'colors',
		
	) );
	
	Kirki::add_field( 'match_fields', array(
		'type'        => 'color',
		'settings'    => 'match_link_color',
		'label'       => esc_attr__( 'Link Color', 'atis' ),
		'default'     => '#dcb161',
		'section'     => 'colors',
	) );

	Kirki::add_field( 'match_fields', array(
		'type'        => 'color',
		'settings'    => 'match_heavy_color',
		'label'       => esc_attr__( 'Heavy Color for Headings', 'atis' ),
		'default'     => '#232e4e',
		'section'     => 'colors',
	) );
	
	//nav
	
	Kirki::add_field( 'match_fields', array(
		'type'        => 'color',
		'settings'    => 'match_menu_normal_color',
		'label'       => esc_attr__( 'Menu Item - Normal State Color', 'atis' ),
		'default'     => '#ffffff',
		'section'     => 'colors',
	) );
	
	Kirki::add_field( 'match_fields', array(
		'type'        => 'color',
		'settings'    => 'match_menu_hover_color',
		'label'       => esc_attr__( 'Menu Item - Hover State Color', 'atis' ),
		'default'     => '#ffffff',
		'section'     => 'colors',
	) );
	
	Kirki::add_field( 'match_fields', array(
		'type'        => 'color',
		'settings'    => 'match_submenu_bkg_color',
		'label'       => esc_attr__( 'Menu Item - SubMenu Background Color', 'atis' ),
		'default'     => 'rgba(0,0,0,0.8)',
		'section'     => 'colors',
		'choices'     => [
		'alpha' => true,
	],
	) );
	
	Kirki::add_field( 'match_fields', array(
		'type'        => 'color',
		'settings'    => 'match_submenu_normal_color',
		'label'       => esc_attr__( 'Menu Item - SubMenu Normal Color', 'atis' ),
		'default'     => '#ffffff',
		'section'     => 'colors',
	) );
	
	Kirki::add_field( 'match_fields', array(
		'type'        => 'color',
		'settings'    => 'match_submenu_hover_color',
		'label'       => esc_attr__( 'Menu Item - SubMenu Hover Color', 'atis' ),
		'default'     => '#dcb161',
		'section'     => 'colors',
	) );
	
	Kirki::add_field( 'match_fields', array(
		'type'        => 'color',
		'settings'    => 'match_footer_bkg_color',
		'label'       => esc_attr__( 'Footer - Background Color', 'atis' ),
		'default'     => '#141c2c',
		'section'     => 'colors',
	) );
	
	Kirki::add_field( 'match_fields', array(
		'type'        => 'color',
		'settings'    => 'match_footer_txt_color',
		'label'       => esc_attr__( 'Footer - Text Color', 'atis' ),
		'default'     => '#ffffff',
		'section'     => 'colors',
	) );
	
	//typography	
	
	Kirki::add_field( 'match_fields', array(
		'type'        => 'select',
		'settings'    => 'match_body_font',
		'label'       => esc_attr__( 'Body - Font Family', 'atis' ),
		'default'     => 'Work Sans',
		'section'     => 'match_typography_options',
		'description'     => esc_attr__( 'Select a font family from the Google Web Fonts', 'atis' ),
		'choices'  => Kirki_Fonts::get_font_choices(),
		'priority'    => 1,
	) );
	
	Kirki::add_field( 'match_fields', array(
		'type'        => 'text',
		'settings'    => 'match_body_font_weight',
		'label'       => esc_attr__( 'Body - Font Weight', 'atis' ),
		'default'     => '400,400i,500,600,700,700i',
		'section'     => 'match_typography_options',
		'description'     => esc_attr__( 'Add body font weights', 'atis' ),
		'priority'    => 2,
	) );
	
	Kirki::add_field( 'match_fields', array(
		'type'        => 'text',
		'settings'    => 'match_body_font_size',
		'label'       => esc_attr__( 'Body - Font Size', 'atis' ),
		'default'     => '15',
		'section'     => 'match_typography_options',
		'description'     => esc_attr__( 'Select body text font size ( in px )', 'atis' ),
		'priority'    => 3,
	) );
	
	Kirki::add_field( 'match_fields', array(
		'type'        => 'select',
		'settings'    => 'match_titles_font',
		'label'       => esc_attr__( 'Titles - Font Family', 'atis' ),
		'default'     => 'Crimson Text',
		'section'     => 'match_typography_options',
		'description'     => esc_attr__( 'Select a font family from the Google Web Fonts', 'atis' ),
		'choices'  => Kirki_Fonts::get_font_choices(),
		'priority'    => 4,
	) );
	
	Kirki::add_field( 'match_fields', array(
		'type'        => 'text',
		'settings'    => 'match_titles_font_weight',
		'label'       => esc_attr__( 'Titles - Font Weight', 'atis' ),
		'default'     => '400,400i,600,600i,700,700i',
		'section'     => 'match_typography_options',
		'description' => esc_attr__( 'Add post titles font weights', 'atis' ),
		'priority'    => 5,
	) );
	
	Kirki::add_field( 'match_fields', array(
		'type'        => 'text',
		'settings'    => 'match_h1_size',
		'label'       => esc_attr__( 'H1 - Font Size', 'atis' ),
		'default'     => '50',
		'section'     => 'match_typography_options',
		'description' => esc_attr__( 'Select H1 heading font size ( in px )', 'atis' ),
		'priority'    => 6,
	) );
	
	Kirki::add_field( 'match_fields', array(
		'type'        => 'text',
		'settings'    => 'match_h2_size',
		'label'       => esc_attr__( 'H2 - Font Size', 'atis' ),
		'default'     => '45',
		'section'     => 'match_typography_options',
		'description' => esc_attr__( 'Select H2 heading font size ( in px )', 'atis' ),
		'priority'    => 7,
	) );
	
	Kirki::add_field( 'match_fields', array(
		'type'        => 'text',
		'settings'    => 'match_h3_size',
		'label'       => esc_attr__( 'H3 - Font Size', 'atis' ),
		'default'     => '35',
		'section'     => 'match_typography_options',
		'description' => esc_attr__( 'Select H3 heading font size ( in px )', 'atis' ),
		'priority'    => 8,
	) );
	
	Kirki::add_field( 'match_fields', array(
		'type'        => 'text',
		'settings'    => 'match_h4_size',
		'label'       => esc_attr__( 'H4 - Font Size', 'atis' ),
		'default'     => '30',
		'section'     => 'match_typography_options',
		'description' => esc_attr__( 'Select H4 heading font size ( in px )', 'atis' ),
		'priority'    => 9,
	) );
	
	Kirki::add_field( 'match_fields', array(
		'type'        => 'text',
		'settings'    => 'match_h5_size',
		'label'       => esc_attr__( 'H5 - Font Size', 'atis' ),
		'default'     => '25',
		'section'     => 'match_typography_options',
		'description' => esc_attr__( 'Select H5 heading font size ( in px )', 'atis' ),
		'priority'    => 10,
	) );
	
	Kirki::add_field( 'match_fields', array(
		'type'        => 'text',
		'settings'    => 'match_h6_size',
		'label'       => esc_attr__( 'H6 - Font Size', 'atis' ),
		'default'     => '15',
		'section'     => 'match_typography_options',
		'description' => esc_attr__( 'Select H6 heading font size ( in px )', 'atis' ),
		'priority'    => 11,
	) );
		
	Kirki::add_field( 'match_fields', array(
		'type'        => 'text',
		'settings'    => 'match_social_facebook_url',
		'label'       => esc_attr__( 'Facebook URL', 'atis' ),
		'default'     => '',
		'section'     => 'match_social_media',
		'description' => esc_attr__( 'Add Facebook URL', 'atis' ),
	) );
	
	Kirki::add_field( 'match_fields', array(
		'type'        => 'text',
		'settings'    => 'match_social_twitter_url',
		'label'       => esc_attr__( 'Twitter URL', 'atis' ),
		'default'     => '',
		'section'     => 'match_social_media',
		'description' => esc_attr__( 'Add Twitter URL', 'atis' ),
	) );
	
	Kirki::add_field( 'match_fields', array(
		'type'        => 'text',
		'settings'    => 'match_social_instagram_url',
		'label'       => esc_attr__( 'Instagram URL', 'atis' ),
		'default'     => '',
		'section'     => 'match_social_media',
		'description' => esc_attr__( 'Add Instagram URL', 'atis' ),
	) );
	
	Kirki::add_field( 'match_fields', array(
		'type'        => 'text',
		'settings'    => 'match_social_linkedin_url',
		'label'       => esc_attr__( 'Linkedin URL', 'atis' ),
		'default'     => '',
		'section'     => 'match_social_media',
		'description' => esc_attr__( 'Add Linkedin URL', 'atis' ),
	) );
	
	Kirki::add_field( 'match_fields', array(
		'type'        => 'text',
		'settings'    => 'match_social_pinterest_url',
		'label'       => esc_attr__( 'Pinterest URL', 'atis' ),
		'default'     => '',
		'section'     => 'match_social_media',
		'description' => esc_attr__( 'Add Pinterest URL', 'atis' ),
	) );
	
	Kirki::add_field( 'match_fields', array(
		'type'        => 'text',
		'settings'    => 'match_social_trip_url',
		'label'       => esc_attr__( 'Trip Advisor URL', 'atis' ),
		'default'     => '',
		'section'     => 'match_social_media',
		'description' => esc_attr__( 'Add Trip Advisor URL', 'atis' ),
	) );
	
	Kirki::add_field( 'match_fields', array(
		'type'        => 'text',
		'settings'    => 'match_social_youtube_url',
		'label'       => esc_attr__( 'YouTube URL', 'atis' ),
		'default'     => '',
		'section'     => 'match_social_media',
		'description' => esc_attr__( 'Add YouTube URL', 'atis' ),
	) );
	
	Kirki::add_field( 'match_fields', array(
		'type'        => 'text',
		'settings'    => 'match_social_vimeo_url',
		'label'       => esc_attr__( 'Vimeo URL', 'atis' ),
		'default'     => '',
		'section'     => 'match_social_media',
		'description' => esc_attr__( 'Add Vimeo URL', 'atis' ),
	) );
	
	Kirki::add_field( 'match_fields', array(
		'type'        => 'text',
		'settings'    => 'match_social_whatsapp_url',
		'label'       => esc_attr__( 'WhatsApp URL', 'atis' ),
		'default'     => '',
		'section'     => 'match_social_media',
		'description' => esc_attr__( 'Add WhatsApp URL', 'atis' ),
	) );
	
	Kirki::add_field( 'match_fields', array(
		'type'        => 'text',
		'settings'    => 'match_social_skype_url',
		'label'       => esc_attr__( 'Skype URL', 'atis' ),
		'default'     => '',
		'section'     => 'match_social_media',
		'description' => esc_attr__( 'Add Skype URL', 'atis' ),
	) );
	
	Kirki::add_field( 'match_fields', array(
		'type'        => 'text',
		'settings'    => 'match_social_email_url',
		'label'       => esc_html__( 'Email Address', 'atis' ),
		'default'     => '',
		'section'     => 'match_social_media',
		'description' => esc_html__( 'Add email address', 'atis' ),
	) );

endif;