<?php get_header(); ?>

<?php $image = wp_get_attachment_image_src( get_post_thumbnail_id( get_option('page_for_posts') ), 'full' );

$blog_page_title = get_the_title(get_option('page_for_posts'));
$match_page_title = get_post_meta(get_option('page_for_posts'), "match_page_title", true);
$match_page_subtitle = get_post_meta(get_option('page_for_posts'), "match_page_subtitle", true);
?>

<?php if(!is_front_page() ):?> 

<div class="top-single-bkg" <?php if(!empty($image)):?> style="background-image:url('<?php echo esc_url($image[0]); ?>');" <?php endif;?>>
	
	<div class="inner-desc">
		<div class="container">
		<?php if(!empty($match_page_subtitle)): ?>
		<span class="post-subtitle"> <?php echo esc_html($match_page_subtitle); ?></span>
        <?php endif; ?>
		<?php if(!empty($match_page_title)): ?>
		<h1 class="display-2 single-post-title"> <?php echo esc_html($match_page_title); ?> </h1>
		  <?php else: ?>
		  <h1 class="display-2 single-post-title"> <?php echo esc_html($blog_page_title); ?> </h1>
		<?php endif; ?>
		</div>
	</div>
	
</div>

<?php else: ?>

<div class="top-single-bkg">
	
	<div class="inner-desc">
		<div class="container">
		<span class="post-subtitle"><?php bloginfo('description'); ?></span>
		  <h1 class="display-2 single-post-title"> <?php bloginfo('name'); ?> </h1>
		</div>
	</div>
	
</div>

<?php endif; ?>


<?php $match_sidebar = get_theme_mod( 'match_sidebar', 'match_sidebar_right'); ?>
<div class="container blog-holder">
<div class="row">
	<?php if ( is_active_sidebar( 'sidebar-1' ) && ( $match_sidebar != 'match_sidebar_no' ) ): ?>
	<div class="col-lg-9 <?php if ( $match_sidebar == 'match_sidebar_left' ): ?> posts-holder-push-right <?php else: ?> posts-holder post-sidebar <?php endif; ?>">
		<?php else: ?>
		<div class="col-lg-12 posts-fullwidth">
			<?php endif; ?>
			<?php
				$match_home_articles_layout = get_theme_mod( 'match_home_articles_layout', 'match_home_articles_layout_1col');
				
					switch ($match_home_articles_layout) {
					
					case 'match_home_articles_layout_1col':
				        get_template_part('include/assets/layouts/layout', '1col');
				        break;
					case 'match_home_articles_layout_2col_grid':
				        get_template_part('include/assets/layouts/layout', '2col_grid');
				        break;
					case 'match_home_articles_layout_3col_grid':
				        get_template_part('include/assets/layouts/layout', '3col_grid');
				        break;	
					case 'match_home_articles_layout_1col_list_left':
				        get_template_part('include/assets/layouts/layout', '1col_list_left');
				        break;			
							
						
					default:
				         get_template_part('include/assets/layouts/layout', '1col');
				}
				
				?>
		</div>
		<?php  if ( is_active_sidebar( 'sidebar-1' ) && ( $match_sidebar != 'match_sidebar_no' ) ):  ?>
		<?php get_sidebar(); ?>
		<?php endif; ?>
	</div>
	<!--row-->
</div>
<!--container-->
<?php get_footer(); ?>