<?php
/*
 
 Template Name: FullScreen
 
 */

get_header(); ?>

<?php $image = wp_get_attachment_image_src( get_post_thumbnail_id( $post->ID ), 'full' );

if ( function_exists( 'get_field' )):

$match_page_subtitle = get_field('match_page_subtitle');
$match_page_title = get_field('match_page_title');

endif;
?>

<div class="top-single-bkg topsinglepage" <?php if(!empty($image)):?> style="background-image:url('<?php echo esc_url($image[0]); ?>');" <?php endif;?>>
	
	<div class="inner-desc">
		<div class="container">
		<?php if(!empty($match_page_subtitle)): ?>
		<span class="post-subtitle"> <?php echo esc_html($match_page_subtitle); ?></span>
        <?php endif; ?>
		<?php if(!empty($match_page_title)): ?>
		<h1 class="display-2 single-post-title"> <?php echo esc_html($match_page_title); ?> </h1>
		  <?php else: ?>
		  <h1 class="display-2 single-post-title"> <?php  the_title(); ?> </h1>
		<?php endif; ?>
		</div>
	</div>
	
</div>


<div id="wrap-content" class="page-content">

<?php if (have_posts()) : while (have_posts()) : the_post(); ?>

<div id="post-<?php the_ID(); ?>" class="page-holder custom-page-template page-full fullscreen-page clearfix">

<?php the_content(); ?>

</div>
<?php  endwhile;

else: ?>

<p class="alignc"><?php esc_html_e( 'Sorry, but it seems we can&rsquo;t find what you&rsquo;re looking for. Try the menu above.', 'atis' ); ?></p>

<?php endif; ?>

</div>

<?php get_footer(); ?>